/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.panels.PacksPanelBase;
import com.izforge.izpack.util.IoHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;

public class ImgPacksPanel
extends PacksPanelBase {
    private static final long serialVersionUID = 3977858492633659444L;
    private ArrayList images;
    private JScrollPane descriptionScroller;
    private JLabel imgLabel;
    private GridBagLayout layout;
    private GridBagConstraints gbConstraints;

    public ImgPacksPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata);
    }

    protected void createNormalLayout() {
        this.preLoadImages();
        this.layout = new GridBagLayout();
        this.gbConstraints = new GridBagConstraints();
        this.setLayout(this.layout);
        this.parent.buildConstraints(this.gbConstraints, 0, 0, 1, 1, 0.25, 0.0);
        this.gbConstraints.insets = new Insets(5, 5, 5, 5);
        this.gbConstraints.anchor = 17;
        this.createLabel("PacksPanel.info", "preferences", this.layout, this.gbConstraints);
        this.parent.buildConstraints(this.gbConstraints, 1, 0, 1, 1, 0.5, 0.0);
        this.createLabel("ImgPacksPanel.snap", "tip", this.layout, this.gbConstraints);
        this.tableScroller = new JScrollPane();
        this.parent.buildConstraints(this.gbConstraints, 0, 1, 1, 2, 0.5, 0.0);
        this.gbConstraints.fill = 1;
        this.packsTable = this.createPacksTable(250, this.tableScroller, this.layout, this.gbConstraints);
        this.imgLabel = new JLabel((ImageIcon)this.images.get(0));
        JScrollPane imgScroller = new JScrollPane(this.imgLabel);
        imgScroller.setPreferredSize(this.getPreferredSizeFromImages());
        this.parent.buildConstraints(this.gbConstraints, 1, 1, 1, 1, 0.5, 1.0);
        this.layout.addLayoutComponent(imgScroller, this.gbConstraints);
        this.add(imgScroller);
        Component strut = Box.createVerticalStrut(20);
        this.parent.buildConstraints(this.gbConstraints, 1, 2, 1, 3, 0.0, 0.0);
        this.layout.addLayoutComponent(strut, this.gbConstraints);
        this.add(strut);
        if (this.dependenciesExist) {
            JScrollPane depScroller = new JScrollPane();
            depScroller.setPreferredSize(new Dimension(250, 40));
            this.parent.buildConstraints(this.gbConstraints, 0, 3, 1, 1, 0.5, 0.5);
            this.dependencyArea = this.createTextArea("ImgPacksPanel.dependencyList", depScroller, this.layout, this.gbConstraints);
        }
        this.descriptionScroller = new JScrollPane();
        this.descriptionScroller.setPreferredSize(new Dimension(200, 60));
        this.descriptionScroller.setBorder(BorderFactory.createEmptyBorder());
        this.parent.buildConstraints(this.gbConstraints, 1, 3, 1, 1, 0.5, 0.5);
        this.descriptionArea = this.createTextArea("PacksPanel.description", this.descriptionScroller, this.layout, this.gbConstraints);
        this.parent.buildConstraints(this.gbConstraints, 0, 4, 2, 1, 0.0, 0.0);
        this.createLabel("PacksPanel.tip", "tip", this.layout, this.gbConstraints);
        this.parent.buildConstraints(this.gbConstraints, 0, 5, 2, 1, 0.0, 0.0);
        this.spaceLabel = this.createPanelWithLabel("PacksPanel.space", this.layout, this.gbConstraints);
        if (IoHelper.supported("getFreeSpace")) {
            this.parent.buildConstraints(this.gbConstraints, 0, 6, 2, 1, 0.0, 0.0);
            this.freeSpaceLabel = this.createPanelWithLabel("PacksPanel.freespace", this.layout, this.gbConstraints);
        }
    }

    private void preLoadImages() {
        int size = this.idata.availablePacks.size();
        this.images = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            try {
                URL url = ResourceManager.getInstance().getURL("ImgPacksPanel.img." + i);
                ImageIcon img = new ImageIcon(url);
                this.images.add(img);
                continue;
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
    }

    private Dimension getPreferredSizeFromImages() {
        int maxWidth = 80;
        int maxHeight = 60;
        Iterator it = this.images.iterator();
        while (it.hasNext()) {
            ImageIcon icon = (ImageIcon)it.next();
            maxWidth = Math.max(maxWidth, icon.getIconWidth());
            maxHeight = Math.max(maxHeight, icon.getIconHeight());
        }
        maxWidth = Math.min(maxWidth + 20, this.idata.guiPrefs.width - 150);
        maxHeight = Math.min(maxHeight + 20, this.idata.guiPrefs.height - 150);
        return new Dimension(maxWidth, maxHeight);
    }

    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        int i = this.packsTable.getSelectedRow();
        if (i >= 0) {
            this.imgLabel.setIcon((ImageIcon)this.images.get(i));
        }
    }
}

